__UNICODE__     equ     TRUE

.586
.model flat,stdcall
option casemap:none

WinMain     PROTO   :DWORD,:DWORD,:DWORD,:DWORD

include c:\masm32\include\windows.inc
include c:\masm32\include\kernel32.inc
include c:\masm32\include\user32.inc
include c:\masm32\include\comctl32.inc
include c:\masm32\include\advapi32.inc

include c:\masm32\macros\macros.asm

includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\comctl32.lib
includelib c:\masm32\lib\advapi32.lib

MainWindowWidth     equ     600
MainWindowHeight    equ     400

.data

; ++++ Application related ++++

hInstance       dd      ?
CommandLine     LPSTR	?

; ++++ Main Window related ++++

hMainWindow     dd      ?
UCSTR           szMainWindowName,"Service Control Manager",0
UCSTR           szMainWindowClass,"Main Window Class",0
wcMainWindow    WNDCLASSEX      <sizeof WNDCLASSEX,CS_HREDRAW or CS_VREDRAW,\
                                offset WndProc,NULL,NULL,?,?,?,COLOR_WINDOW,0,\
                                offset szMainWindowClass,?>

; ++++ ListView related ++++

UCSTR           szListViewClass,"SysListView32",0
UCSTR           szListViewName,"ListView32",0

hListView       DD      ?
lvi             LV_ITEM     <>
lvc             LV_COLUMN   <0>
UCSTR           szService,"Service",0
UCSTR           szServiceDisplayName,"Service Display Name",0
UCSTR           szState,"State",0
UCSTR           szServiceStopped,"STOPPED",0
UCSTR           szServiceRunning,"RUNNING",0
UCSTR           szServicePaused,"PAUSED",0

; +++++ Servire Control Manager related +++++

hSCManager      dd      ?
lpServicesStatus        dd   ?
essNeeded       dd      ?
essBytesReturned    dd  ?
ServicesReturned    dd  ?
ResumeVariable  dd      0
       

; ++++ other vars and STRUCTs +++++

rect            RECT        <>
iccx            INITCOMMONCONTROLSEX <sizeof INITCOMMONCONTROLSEX,ICC_LISTVIEW_CLASSES>
                                
.code
    start:
       
        invoke  GetModuleHandle,0
        mov     hInstance,eax
        invoke  GetCommandLine
        mov     CommandLine,eax
        invoke  InitCommonControlsEx,addr iccx
        invoke  WinMain,hInstance,0,0,SW_SHOWNORMAL
        invoke  ExitProcess,eax

WinMain PROC    hInst:DWORD,hPrevInst:DWORD,CmdLine:DWORD,CmdShow:DWORD

        local   msg:MSG

        invoke  LoadIcon,0,IDI_APPLICATION
        mov     wcMainWindow.hIcon,eax
        mov     wcMainWindow.hIconSm,eax
        invoke  LoadCursor,0,IDC_ARROW
        mov     wcMainWindow.hCursor,eax
        push    hInst
        pop     wcMainWindow.hInstance
        invoke  RegisterClassEx,addr wcMainWindow
        invoke  GetSystemMetrics,SM_CYSCREEN
        shr     eax,1
        sub     eax,MainWindowHeight/2
        push    eax
        invoke  GetSystemMetrics,SM_CXSCREEN
        shr     eax,1
        sub     eax,MainWindowWidth/2
        pop     ebx
        invoke  CreateWindowEx,0,addr szMainWindowClass,addr szMainWindowName,WS_TILEDWINDOW,\
                    eax,ebx,MainWindowWidth,MainWindowHeight,NULL,NULL,hInst,NULL
        mov     hMainWindow,eax
        invoke  ShowWindow,eax,SW_SHOWNORMAL
        invoke  UpdateWindow,hMainWindow

msg_loop:
        invoke  GetMessage,addr msg,NULL,0,0
        or      eax,eax
        jz      end_msg_loop
        invoke  TranslateMessage,addr msg
        invoke  DispatchMessage,addr msg
        jmp     msg_loop
end_msg_loop:
        mov     eax,msg.wParam
        ret
        
WinMain endp


WndProc PROC    hWnd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

        .if     uMsg==WM_DESTROY
                invoke  PostQuitMessage,0

        .elseif uMsg==WM_CREATE
            mov edi,lParam

                .if [edi.CREATESTRUCT.hWndParent]==0
                    invoke  GetClientRect,hWnd,addr rect
                    invoke  CreateWindowEx,LVS_EX_GRIDLINES,addr szListViewClass,addr szListViewName,WS_VISIBLE\
                               or WS_CHILD or LVS_REPORT or LVS_AUTOARRANGE OR WS_VSCROLL,0,0,rect.right,rect.bottom,\
                               hWnd,0,hInstance,0
                    mov hListView,eax
                    mov     lvc.imask,LVCF_TEXT or LVCF_WIDTH
                    mov     lvc.pszText,offset szService
                    shr     rect.right,2
                    push    rect.right
                    pop     lvc.lx
                    invoke  SendMessage,hListView,LVM_INSERTCOLUMN,1,addr lvc
                    mov     lvc.pszText,offset szServiceDisplayName
                    shl     rect.right,1
                    push    rect.right
                    pop     lvc.lx
                    invoke  SendMessage,hListView,LVM_INSERTCOLUMN,2,addr lvc
                    shr     rect.right,1
                    push    rect.right
                    pop     lvc.lx
                    mov     lvc.pszText,offset szState
                    invoke  SendMessage,hListView,LVM_INSERTCOLUMN,3,addr lvc
                    
                    invoke  OpenSCManager,0,0,SC_MANAGER_ENUMERATE_SERVICE or GENERIC_READ
                    mov     hSCManager,eax
                    invoke  EnumServicesStatus,hSCManager,SERVICE_WIN32 or SERVICE_DRIVER,SERVICE_STATE_ALL,\
                                NULL,0,addr essNeeded,addr ServicesReturned,addr ResumeVariable
                    invoke  LocalAlloc,LMEM_FIXED,essNeeded 
                    mov     lpServicesStatus,eax
                    mov     lvi.imask,LVIF_TEXT
                    mov     lvi.iItem,0
;enum_loop:
                    invoke  EnumServicesStatus,hSCManager,SERVICE_WIN32 or SERVICE_DRIVER,SERVICE_STATE_ALL,\
                                  lpServicesStatus,essNeeded,addr essNeeded,\
                                  addr ServicesReturned,addr ResumeVariable
                    mov     edi,lpServicesStatus                                  
                    mov     ecx,ServicesReturned
enum_loop:                    
                    push    ecx
                    push    [edi.ENUM_SERVICE_STATUS.lpServiceName]
                    pop     lvi.pszText
                    invoke  SendMessage,hListView,LVM_INSERTITEM,0,addr lvi
                    push    [edi.ENUM_SERVICE_STATUS.lpDisplayName]
                    pop     lvi.pszText
                    inc     lvi.iSubItem
                    invoke  SendMessage,hListView,LVM_SETITEM,0,addr lvi
                    mov     eax,[edi.ENUM_SERVICE_STATUS].ServiceStatus.dwCurrentState
                    inc     lvi.iSubItem
                    .if     eax==SERVICE_STOPPED
                        mov     lvi.pszText,offset szServiceStopped
                        invoke  SendMessage,hListView,LVM_SETITEM,0,addr lvi
                    .elseif eax==SERVICE_RUNNING
                        mov     lvi.pszText,offset szServiceRunning
                        invoke  SendMessage,hListView,LVM_SETITEM,0,addr lvi
                    .elseif eax==SERVICE_PAUSED
                        mov     lvi.pszText,offset szServicePaused
                        invoke  SendMessage,hListView,LVM_SETITEM,0,addr lvi
                    .endif
                    mov     lvi.iSubItem,0
                    inc     lvi.iItem
                    add     edi,sizeof ENUM_SERVICE_STATUS
                    pop     ecx
                    dec     ecx
                    or      ecx,ecx
                    jnz     enum_loop

end_enum_loop:
                    invoke  CloseServiceHandle,hSCManager                                       

                .endif                    
        .elseif uMsg==WM_SIZE
                invoke  GetClientRect,hWnd,addr rect
                invoke SetWindowPos,hListView,0,0,0,rect.right,rect.bottom,SWP_SHOWWINDOW
        .else
                invoke  DefWindowProc,hWnd,uMsg,wParam,lParam
                ret
        .endif
        xor eax,eax
        ret
        
WndProc endp

end start
